/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class ConnectLog
implements CommandListener {
    private Form form;
    private Command close = new Command("Close session", 4, 0);
    private NetworkThread thread;
    private RosterList roster;
    private Display d;
    private JabberProfile jp;
    private static ConnectLog instance = null;

    public static ConnectLog getInstance() {
        if (instance == null) {
            instance = new ConnectLog();
        }
        return instance;
    }

    private ConnectLog() {
        this.form = new Form("Network log");
        this.form.setCommandListener((CommandListener)this);
        this.form.addCommand(this.close);
    }

    public void setCurrent() {
        this.d.setCurrent((Displayable)this.form);
    }

    public void newSession(Display d, JabberProfile jp) {
        this.d = d;
        this.jp = jp;
        d.setCurrent((Displayable)this.form);
        this.thread = new NetworkThread(this);
    }

    public void initRoster() {
        this.roster = new RosterList(this.d, this.jp);
        this.roster.setThread(this.thread);
        this.roster.init();
    }

    public void addMessage(String m) {
        try {
            if (this.thread.isEnded()) {
                return;
            }
            Calendar cl = Calendar.getInstance();
            int h = 0;
            h = cl.get(11);
            String tim = h + ":" + (cl.get(12) < 10 ? "0" + cl.get(12) : "" + cl.get(12)) + ":" + (cl.get(13) < 10 ? "0" : "") + cl.get(13) + " ";
            if (this.form.size() > 10) {
                this.form.delete(this.form.size() - 1);
            }
            StringItem t2 = new StringItem(null, tim + m);
            t2.setLayout(512);
            this.form.insert(0, (Item)t2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Display getDisplay() {
        return this.d;
    }

    public JabberProfile getProfile() {
        return this.jp;
    }

    public NetworkThread getThread() {
        return this.thread;
    }

    public void setThread(NetworkThread thread) {
        this.thread = thread;
    }

    public RosterList getRoster() {
        return this.roster;
    }

    public void setRoster(RosterList roster) {
        this.roster = roster;
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0.equals(this.close)) {
            this.getProfile().setAutoReconnect(0);
            this.thread.terminate(false);
            new ProfileList(this.d);
            return;
        }
    }
}

