/*
 * Decompiled with CFR 0.152.
 */
import custom.RichText;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;

public class MailViewer
implements CommandListener {
    private Form f;
    private Command exit;
    private Display d;
    private RosterList rl;
    private int mailCount = 0;
    private Image mailImg = RosterItem.getImage("/imgs/mail_icon.png");

    public MailViewer(Display d, RosterList rl) {
        this.d = d;
        this.rl = rl;
        this.f = new Form("No new mail");
        this.exit = new Command("Close", 4, 0);
        this.f.addCommand(this.exit);
        this.f.setCommandListener((CommandListener)this);
    }

    public void addMail(String from, String subj, String body) {
        ++this.mailCount;
        RichText rt = new RichText(this.d);
        rt.setCanvasWidth(this.rl.getRoster().getWidth());
        rt.addImage(this.mailImg);
        rt.addContent(" From: ", rt.getDefaultColor(), true);
        rt.addContent(from + "\n");
        rt.addContent("Subject: ", rt.getDefaultColor(), true);
        rt.addContent(subj + "\n");
        rt.addContent(body);
        rt.finish();
        this.f.insert(0, (Item)rt);
        this.f.setTitle("New messages: " + this.mailCount);
    }

    public void startMe() {
        this.d.setCurrent((Displayable)this.f);
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0.equals(this.exit)) {
            this.mailCount = 0;
            this.d.setCurrent((Displayable)this.rl.getRoster());
        }
    }
}

