/*
 * Decompiled with CFR 0.152.
 */
import com.twmacinta.util.MD5;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SocketConnection;

public class NetworkThread
extends Thread {
    private boolean ended = false;
    private boolean busy = false;
    private boolean google = false;
    private boolean terminated = false;
    private boolean statusSet = false;
    private String token = "";
    private boolean inCycle = false;
    private ConnectLog log;
    private SocketConnection conn;
    private boolean isSecure = false;
    private InputStream is = null;
    private OutputStream os = null;
    private static String MY_SERVER = "http://temp.27-i.net/servlet/GenerateToken?";

    public static String ToUTF(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                stringbuffer.append(c);
            }
            if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                stringbuffer.append((char)(0xC0 | 0x1F & c >> 6));
                stringbuffer.append((char)(0x80 | 0x3F & c));
            }
            if (c < '\u0800' || c > '\uffff') continue;
            stringbuffer.append((char)(0xE0 | 0xF & c >> 12));
            stringbuffer.append((char)(0x80 | 0x3F & c >> 6));
            stringbuffer.append((char)(0x80 | 0x3F & c));
        }
        return stringbuffer.toString();
    }

    private void reconnect() {
        this.ended = true;
        if (this.log.getProfile().getAutoReconnect() > 0) {
            this.log.newSession(this.log.getDisplay(), this.log.getProfile());
        }
    }

    public synchronized void terminate() {
        this.terminate(true);
    }

    public synchronized void terminate(boolean play) {
        if (this.terminated) {
            return;
        }
        try {
            this.log.addMessage("Disconnected");
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.ended = true;
        this.terminated = true;
        try {
            this.conn.close();
            this.is.close();
            this.os.close();
        }
        catch (Exception e) {
            System.out.println("Ex1");
        }
        try {
            this.log.setCurrent();
        }
        catch (Exception e1) {
            System.out.println("Ex2");
        }
        this.notify();
        System.out.println("Ended set to true");
        try {
            Thread.sleep(510L);
            if (play) {
                this.reconnect();
            }
        }
        catch (Exception e) {
            System.out.println("Ex3");
        }
    }

    public NetworkThread(ConnectLog l) {
        this.log = l;
        this.start();
    }

    public void run() {
        this.log.addMessage("Connecting...");
        String user = this.log.getProfile().getUser();
        if (user.indexOf("@") == -1) {
            this.log.addMessage("Invalid username " + user);
            this.reconnect();
            return;
        }
        String domain = user.substring(user.indexOf("@") + 1, user.length());
        user = user.substring(0, user.indexOf("@"));
        String addr = this.log.getProfile().getHost() + ":" + this.log.getProfile().getPort();
        addr = this.log.getProfile().getSsl() == 1 ? "ssl://" + addr : "socket://" + addr;
        if (this.log.getProfile().getIsGoogle() > 0) {
            this.token = this.log.getProfile().getUseMyServer() > 0 ? this.getGoogleTokenViaMyServer(this.log.getProfile().getUser(), this.log.getProfile().getPass()) : this.getGoogleToken(this.log.getProfile().getUser(), this.log.getProfile().getPass());
        }
        if (this.ended) {
            this.reconnect();
            return;
        }
        try {
            this.startSession(addr, domain, user, this.log.getProfile().getPass(), "Mobile", this.log.getProfile().getStatus());
        }
        catch (Exception e) {
            this.log.addMessage(e.getMessage());
            this.reconnect();
            return;
        }
        if (this.ended) {
            this.reconnect();
            return;
        }
        this.log.addMessage("Successfully connected with " + this.log.getProfile().getUser());
        String show = "";
        if (this.log.getProfile().getStatusID() == 1) {
            show = "away";
        }
        if (this.log.getProfile().getStatusID() == 2) {
            show = "xa";
        }
        if (this.log.getProfile().getStatusID() == 3) {
            show = "dnd";
        }
        if (this.isGoogle()) {
            if (this.ended) {
                this.reconnect();
                return;
            }
            System.out.println("isGoogle");
            this.writeToAir("<iq type=\"get\" id=\"6\"><query xmlns=\"google:relay\"/></iq>");
            XmlNode y = this.readStanza();
            if (y.getAttr("type").equals("error")) {
                this.ended = true;
            } else {
                this.writeToAir("<iq type=\"set\" to=\"" + this.log.getProfile().getUser() + "\" id=\"15\"><usersetting xmlns=\"google:setting\"><autoacceptrequests value=\"false\"/>" + "<mailnotifications value=\"true\"/></usersetting></iq>");
                y = this.readStanza();
                if (y.getAttr("type").equals("error")) {
                    this.ended = true;
                }
            }
        }
        if (!this.ended) {
            if (!this.isGoogle()) {
                this.writeToAir("<presence><show>" + show + "</show><status>" + this.log.getProfile().getStatus() + "</status></presence>");
            }
            this.writeToAir("<iq type=\"get\" id=\"roster\"><query xmlns=\"jabber:iq:roster\"/></iq>");
            if (this.isGoogle()) {
                this.writeToAir("<presence><show></show><status></status></presence>");
                this.writeToAir("<iq type=\"get\" id=\"23\"><query xmlns=\"google:mail:notify\" q=\"(!label:^s) (!label:^k) ((label:^u) (label:^i) (!label:^vm))\"/></iq><iq type=\"get\" to=\"" + this.log.getProfile().getUser() + "\" id=\"21\"><query xmlns=\"google:shared-status\"/></iq>");
            }
        }
        long nowTime = new Date().getTime();
        this.inCycle = true;
        this.log.initRoster();
        this.log.getRoster().getRoster().setTitle(this.log.getProfile().getUser());
        while (!this.ended) {
            try {
                if (this.is.available() > 0 && !this.busy) {
                    int i;
                    Vector v;
                    XmlNode x = this.readOneStanza();
                    if (x.getName().equals("")) continue;
                    if (x.getName().equals("iq") && x.child("query").getAttr("xmlns").equals("jabber:iq:roster")) {
                        v = x.child("query").getChilds();
                        this.log.getRoster().setFullJid(x.getAttr("to"));
                        for (i = 0; i < v.size(); ++i) {
                            XmlNode y = (XmlNode)v.elementAt(i);
                            if (!y.getAttr("subscription").equals("both")) continue;
                            this.log.getRoster().getRosterFactory().updateContact(y.getAttr("jid").toLowerCase(), y.getAttr("name"), null, null);
                        }
                    }
                    if (x.getName().equals("presence")) {
                        this.log("Need to change presence");
                        if (x.getAttr("type").equals("subscribe")) {
                            this.log.getRoster().playMessage();
                            new RequestAuth(this.log.getDisplay(), this, this.log.getDisplay().getCurrent(), x.getAttr("from"), this.log.getProfile().getUser());
                        }
                        this.log.getRoster().getRosterFactory().updateContact(x.getAttr("from").toLowerCase(), null, x.getAttr("type").equals("") ? x.childValue("show") : x.getAttr("type"), x.childValue("status"));
                    }
                    if (x.getName().equals("message") && !x.getAttr("type").equals("error")) {
                        this.log.getRoster().getRosterFactory().addMessage(x.getAttr("from").toLowerCase(), x.childValue("body"), x.getAttr("id"));
                    }
                    if (x.getName().equals("iq") && x.child("query").getAttr("xmlns").equals("jabber:iq:version")) {
                        System.out.println("Proceed");
                        this.writeToAir("<iq type=\"error\" to=\"" + x.getAttr("from") + "\"><query xmlns=\"jabber:iq:version\"/><error code=\"501\" type=\"cancel\"><feature-not-implemented xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\"/></error></iq>");
                    }
                    if (x.getName().equals("iq") && this.isGoogle() && !x.child("mailbox").getAttr("result-time").equals("")) {
                        v = x.child("mailbox").getChilds();
                        for (i = v.size() - 1; i >= 0; --i) {
                            XmlNode t = (XmlNode)v.elementAt(i);
                            if (i == 0) {
                                this.log.getRoster().setLastTime(t.getAttr("date"));
                                this.log.getRoster().setTid(t.getAttr("tid"));
                            }
                            this.log.getRoster().getMails().addMail(t.child("senders").child("sender").getAttr("name"), t.childValue("subject"), t.childValue("snippet"));
                        }
                        if (v.size() > 0) {
                            this.log.getRoster().getMails().startMe();
                            this.log.getRoster().playMessage();
                        }
                    }
                    if (x.getName().equals("iq") && this.isGoogle() && x.child("new-mail").getAttr("xmlns").equals("google:mail:notify")) {
                        this.writeToAir("<iq type=\"get\"><query xmlns=\"google:mail:notify\"" + (this.log.getRoster().getLastTime().equals("") ? "" : " newer-than-time=\"" + this.log.getRoster().getLastTime() + "\"") + (this.log.getRoster().getTid().equals("") ? "" : " newer-than-tid=\"" + this.log.getRoster().getTid() + "\"") + " q=\"(!label:^s) (!label:^k) ((label:^u) (label:^i) (!label:^vm))\"/></iq>");
                    }
                    if (!x.getName().equals("iq") || !this.isGoogle() || !x.child("query").getAttr("xmlns").equals("google:shared-status")) continue;
                    if (this.statusSet || this.log.getProfile().getLockStatusStr() == 0) {
                        this.log.getProfile().setStatus(x.child("query").childValue("status"));
                    }
                    int newStatus = x.child("query").childValue("show").equals("") ? 0 : (x.child("query").childValue("show").equals("away") ? 1 : 3);
                    this.log.getRoster().getOnlines().removeAllElements();
                    this.log.getRoster().getBusies().removeAllElements();
                    this.log.getRoster().getAways().removeAllElements();
                    Vector v2 = x.child("query").getChilds();
                    for (int i2 = 0; i2 < v2.size(); ++i2) {
                        XmlNode t = (XmlNode)v2.elementAt(i2);
                        if (!t.getName().equals("status-list")) continue;
                        Vector v22 = t.getChilds();
                        for (int j = 0; j < v22.size(); ++j) {
                            XmlNode t2 = (XmlNode)v22.elementAt(j);
                            if (t.getAttr("show").equals("dnd")) {
                                this.log.getRoster().getBusies().addElement(t2.getValue());
                                continue;
                            }
                            if (t.getAttr("show").equals("away")) {
                                this.log.getRoster().getAways().addElement(t2.getValue());
                                continue;
                            }
                            this.log.getRoster().getOnlines().addElement(t2.getValue());
                        }
                    }
                    if (this.log.getProfile().getStatusID() == 2) {
                        this.log.getProfile().setStatusID(1);
                    }
                    if (newStatus != this.log.getProfile().getStatusID() && this.log.getProfile().getLockStatus() > 0) {
                        this.generatePresense();
                    } else {
                        this.log.getProfile().setStatusID(newStatus);
                    }
                    if (this.statusSet || this.log.getProfile().getLockStatusStr() <= 0) continue;
                    this.statusSet = true;
                    this.generatePresense();
                    continue;
                }
                if (!this.busy && new Date().getTime() - nowTime > 600000L) {
                    show = "";
                    if (this.log.getProfile().getStatusID() == 1) {
                        show = "away";
                    }
                    if (this.log.getProfile().getStatusID() == 2) {
                        show = "xa";
                    }
                    if (this.log.getProfile().getStatusID() == 3) {
                        show = "dnd";
                    }
                    nowTime = new Date().getTime();
                    this.writeToAir("<presence from=\"" + this.log.getRoster().getFullJid() + "\"><show>" + show + "</show><status>" + this.log.getProfile().getStatusStr() + "</status></presence>");
                }
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.ended = true;
            }
        }
        this.terminate();
    }

    public XmlNode readStanza() {
        this.busy = true;
        XmlNode x = new XmlNode();
        if (this.ended) {
            this.terminate();
            return x;
        }
        do {
            if (this.ended) continue;
            try {
                x.init("", this.is);
            }
            catch (Exception e) {
                this.ended = true;
            }
            this.busy = false;
        } while (x.getName().equals("") && !this.ended);
        System.out.println(x);
        return x;
    }

    public XmlNode readOneStanza() {
        this.busy = true;
        XmlNode x = new XmlNode();
        if (this.ended) {
            this.terminate();
            return x;
        }
        if (!this.ended) {
            try {
                x.init("", this.is);
            }
            catch (Exception e) {
                this.ended = true;
            }
            this.busy = false;
        }
        System.out.println("RO:" + x);
        return x;
    }

    private String Base16Encode(String s) {
        String res = "";
        for (int i = 0; i < s.length(); ++i) {
            res = res + Integer.toHexString(s.charAt(i));
        }
        return res;
    }

    public void writeToAir(String mess) {
        if (this.ended) {
            this.terminate();
            return;
        }
        try {
            if (this.os != null) {
                this.os.write(NetworkThread.ToUTF(mess).getBytes());
                this.os.flush();
            }
        }
        catch (Exception e) {
            this.ended = true;
        }
    }

    private Connection getConnection() {
        return this.conn;
    }

    private void initConnection(String addr) throws Exception {
        try {
            this.log.addMessage("Init connection to " + addr);
            this.conn = (SocketConnection)Connector.open((String)addr);
            this.conn.setSocketOption((byte)2, 1);
            this.is = this.conn.openInputStream();
            this.os = this.conn.openOutputStream();
            this.isSecure = false;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String generateAuthResponse(String user, String pass, String realm, String digest_uri, String nonce, String cnonce) {
        int i;
        String val1 = user + ":" + realm + ":" + pass;
        byte[] bb = new byte[17];
        bb = this.md5It(val1);
        int sl = new String(":" + nonce + ":" + cnonce).length();
        byte[] cc = new String(":" + nonce + ":" + cnonce).getBytes();
        byte[] bc = new byte[99];
        for (i = 0; i < 16; ++i) {
            bc[i] = bb[i];
        }
        for (i = 16; i < sl + 16; ++i) {
            bc[i] = cc[i - 16];
        }
        String val2 = new String(MD5.toHex(this.md5It(bc, sl + 16)));
        String val3 = "AUTHENTICATE:" + digest_uri;
        val3 = MD5.toHex(this.md5It(val3));
        String val4 = val2 + ":" + nonce + ":00000001:" + cnonce + ":auth:" + val3;
        val4 = MD5.toHex(this.md5It(val4));
        String enc = "charset=utf-8,username=\"" + user + "\",realm=\"" + realm + "\"," + "nonce=\"" + nonce + "\",cnonce=\"" + cnonce + "\"," + "nc=00000001,qop=auth,digest-uri=\"" + digest_uri + "\"," + "response=" + val4;
        String resp = MD5.toBase64(enc.getBytes());
        return resp;
    }

    public byte[] md5It(String s) {
        byte[] bb = new byte[16];
        try {
            MD5 md2 = new MD5(s.getBytes());
            return md2.doFinal();
        }
        catch (Exception e) {
            e.printStackTrace();
            return bb;
        }
    }

    public byte[] md5It(byte[] s, int l) {
        byte[] bb = new byte[16];
        try {
            byte[] tmp = new byte[l];
            for (int i = 0; i < l; ++i) {
                tmp[i] = s[i];
            }
            MD5 md2 = new MD5(tmp);
            return md2.doFinal();
        }
        catch (Exception e) {
            e.printStackTrace();
            return bb;
        }
    }

    private void log(String s) {
    }

    private String readLine(DataInputStream dis) {
        String s = "";
        byte ch = 0;
        try {
            while ((ch = dis.readByte()) != -1) {
                if (ch == 10) {
                    return s;
                }
                s = s + (char)ch;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    private String getGoogleToken(String userName, String passwd) {
        String first = "Email=" + userName + "&Passwd=" + passwd + "&PersistentCookie=false&source=googletalk";
        try {
            HttpsConnection c = (HttpsConnection)Connector.open((String)("https://www.google.com:443/accounts/ClientAuth?" + first));
            this.log.addMessage("Connecting to www.google.com");
            DataInputStream dis = c.openDataInputStream();
            String str = this.readLine(dis);
            String SID = "";
            String LSID = "";
            if (str.startsWith("SID=") && !this.ended) {
                SID = str.substring(4, str.length());
                str = this.readLine(dis);
                LSID = str.substring(5, str.length());
                first = "SID=" + SID + "&LSID=" + LSID + "&service=mail&Session=true";
                dis.close();
                c.close();
                c = (HttpsConnection)Connector.open((String)("https://www.google.com:443/accounts/IssueAuthToken?" + first));
                this.log.addMessage("Next www.google.com connection");
                dis = c.openDataInputStream();
                str = this.readLine(dis);
                String token = MD5.toBase64(new String("\u0000" + userName + "\u0000" + str).getBytes());
                dis.close();
                c.close();
                return token;
            }
            throw new Exception("Invalid response");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("EX: " + ex.toString());
            return "";
        }
    }

    private String getGoogleTokenViaMyServer(String userName, String passwd) {
        String first = "email=" + userName + "&pass=" + passwd;
        try {
            HttpConnection c = (HttpConnection)Connector.open((String)(MY_SERVER + first));
            this.log.addMessage("Connecting to help server...");
            DataInputStream dis = c.openDataInputStream();
            String str = this.readLine(dis);
            if (!str.equals("") && !this.ended) {
                dis.close();
                c.close();
                return str;
            }
            throw new Exception("Invalid response");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("EX: " + ex.toString());
            return "";
        }
    }

    private void startSession(String addr, String domain, String user, String pass, String resource, String Status) throws Exception {
        try {
            this.initConnection(addr);
            this.log.addMessage("Opening first stream");
            this.log("Initiate stream");
            this.writeToAir("<?xml version=\"1.0\"?><stream:stream to=\"" + domain + "\" xmlns=\"jabber:client\" xmlns:stream=\"http://etherx.jabber.org/streams\" version=\"1.0\">");
            XmlNode x = this.readStanza();
            if (x.getName().equals("stream:error")) {
                throw new Exception("Error opening stream");
            }
            this.log(x.toString());
            this.log.addMessage("Authenticating");
            if (x.child("mechanisms").hasValueOfChild("DIGEST-MD5")) {
                this.log("MD5 authorization doing");
                this.writeToAir("<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" mechanism=\"DIGEST-MD5\"/>");
                this.log.addMessage("Sending authorization data");
                x = this.readStanza();
                if (x.getName().equals("failure")) {
                    throw new Exception("MD5 auth. error");
                }
                String dec = new String(Base64.decode(x.getValue().getBytes()));
                int ind = dec.indexOf("nonce=\"") + 7;
                String nonce = dec.substring(ind, dec.indexOf("\"", ind + 1));
                String cnonce = "00deadbeef00";
                this.writeToAir("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">" + this.generateAuthResponse(user, pass, domain, "xmpp/" + domain, nonce, cnonce) + "</response>");
                this.log.addMessage("Waiting for response");
                x = this.readStanza();
                if (x.getName().equals("failure")) {
                    throw new Exception("MD5 auth. error");
                }
                this.writeToAir("<response xmlns='urn:ietf:params:xml:ns:xmpp-sasl'/>");
                this.log.addMessage("Next authorization step");
                x = this.readStanza();
                if (x.getName().equals("failure")) {
                    throw new Exception("MD5 authorization error");
                }
            } else if (x.child("mechanisms").hasValueOfChild("X-GOOGLE-TOKEN") && this.log.getProfile().getIsGoogle() > 0) {
                this.setGoogle(true);
                String resp = this.token;
                this.writeToAir("<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" mechanism=\"X-GOOGLE-TOKEN\">" + resp + "</auth>");
                this.log.addMessage("Starting google authorization");
                x = this.readStanza();
                if (x.getName().equals("failure")) {
                    throw new Exception("GOOGLE authorization error");
                }
            } else {
                this.log("Using plain authorization");
                String resp = "\u0000" + user + "\u0000" + pass;
                this.writeToAir("<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" mechanism=\"PLAIN\">" + MD5.toBase64(resp.getBytes()) + "</auth>");
                this.log.addMessage("Starting PLAIN authorization");
                x = this.readStanza();
                if (x.getName().equals("failure")) {
                    throw new Exception("PLAIN authorization error");
                }
            }
            this.writeToAir("<?xml version=\"1.0\"?><stream:stream xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"jabber:client\" to=\"" + domain + "\" version=\"1.0\">");
            this.log.addMessage("Opening next stream");
            x = this.readStanza();
            if (x.getValue().equals("stream:error")) {
                throw new Exception("Error opening second stream");
            }
            this.log("Binding resource");
            this.writeToAir("<iq type=\"set\" id=\"bind\"><bind xmlns=\"urn:ietf:params:xml:ns:xmpp-bind\"><resource>" + resource + "</resource></bind></iq>");
            this.log.addMessage("Binding resource");
            x = this.readStanza();
            if (x.getAttr("type").equals("error")) {
                throw new Exception("Error binding resource");
            }
            this.writeToAir("<iq to=\"" + domain + "\" type=\"set\" id=\"sess_1\">" + "<session xmlns=\"urn:ietf:params:xml:ns:xmpp-session\"/></iq>");
            this.log.addMessage("Opening session");
            x = this.readStanza();
            if (x.getAttr("type").equals("error")) {
                throw new Exception("Error opening session");
            }
        }
        catch (Exception e) {
            this.log("Exception found: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    public boolean isGoogle() {
        return this.google;
    }

    public void setGoogle(boolean google) {
        this.google = google;
    }

    public void generatePresense() {
        String outp = "";
        String show = "";
        if (this.log.getProfile().getStatusID() == 1) {
            show = "away";
        }
        if (this.log.getProfile().getStatusID() == 2) {
            show = "xa";
        }
        if (this.log.getProfile().getStatusID() == 3) {
            show = "dnd";
        }
        if (!this.isGoogle()) {
            outp = "<presence><show>" + show + "</show><status>" + this.log.getProfile().getStatus() + "</status></presence>";
        } else {
            int i;
            outp = "<iq type=\"set\" to=\"" + this.log.getProfile().getUser() + "\">" + "<query xmlns=\"google:shared-status\"><status>" + this.log.getProfile().getStatus() + "</status><show>" + show + "</show>";
            String s = "";
            boolean found = false;
            for (i = 0; i < this.log.getRoster().getOnlines().size(); ++i) {
                s = s + "<status>" + this.log.getRoster().getOnlines().elementAt(i).toString() + "</status>";
                if (!this.log.getRoster().getOnlines().elementAt(i).toString().equals(this.log.getProfile().getStatus()) || this.log.getRoster().getProfile().getStatusID() != 0) continue;
                found = true;
            }
            if (!found && this.log.getProfile().getStatusID() == 0 && !this.log.getProfile().getStatus().trim().equals("")) {
                s = "<status>" + this.log.getProfile().getStatus() + "</status>" + s;
            }
            outp = outp + "<status-list show=\"default\">" + s + "</status-list>";
            s = "";
            found = false;
            for (i = 0; i < this.log.getRoster().getBusies().size(); ++i) {
                s = s + "<status>" + this.log.getRoster().getBusies().elementAt(i).toString() + "</status>";
                if (!this.log.getRoster().getBusies().elementAt(i).toString().equals(this.log.getRoster().getProfile().getStatus()) || this.log.getProfile().getStatusID() != 3) continue;
                found = true;
            }
            if (!found && this.log.getProfile().getStatusID() == 3 && !this.log.getProfile().getStatus().trim().equals("")) {
                s = "<status>" + this.log.getProfile().getStatus() + "</status>" + s;
            }
            outp = outp + "<status-list show=\"dnd\">" + s + "</status-list>";
            s = "";
            found = false;
            for (i = 0; i < this.log.getRoster().getAways().size(); ++i) {
                s = s + "<status>" + this.log.getRoster().getAways().elementAt(i).toString() + "</status>";
                if (!this.log.getRoster().getAways().elementAt(i).toString().equals(this.log.getProfile().getStatus()) || this.log.getProfile().getStatusID() != 1) continue;
                found = true;
            }
            if (!found && this.log.getProfile().getStatusID() == 1 && !this.log.getProfile().getStatus().trim().equals("")) {
                s = "<status>" + this.log.getProfile().getStatus() + "</status>" + s;
            }
            outp = outp + "<status-list show=\"away\">" + s + "</status-list>";
            outp = outp + "</query></iq>";
        }
        this.writeToAir(outp);
    }

    public boolean isInCycle() {
        return this.inCycle;
    }

    public void setInCycle(boolean inCycle) {
        this.inCycle = inCycle;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void setEnded(boolean ended) {
        this.ended = ended;
    }
}

