/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class ProfileEdit
implements CommandListener {
    private Form f;
    private JabberProfile j;
    private Command c1;
    private Command c2;
    private Command c3;
    private RecordStore rs;
    private Display d;
    private TextField name;
    private TextField host;
    private TextField user;
    private TextField pass;
    private TextField status;
    private TextField port;
    private TextField histLength;
    private ChoiceGroup ssl;
    private ChoiceGroup auto;
    private ChoiceGroup sortBy;
    private ChoiceGroup statusID;
    private ChoiceGroup offline;
    private ChoiceGroup isGoogle;
    private ChoiceGroup lockStatus;
    private ChoiceGroup lockStatusStr;
    private ChoiceGroup autoReconnect;
    private ChoiceGroup smiles;
    private ChoiceGroup useMyServer;
    private Gauge volume;

    public ProfileEdit(Display d, JabberProfile jp, RecordStore r) {
        this.j = jp;
        this.rs = r;
        this.d = d;
        this.f = new Form("Jabber profile");
        this.c1 = new Command("Save", 3, 1);
        this.c2 = new Command("Delete", 4, 0);
        this.c3 = new Command("Cancel", 4, 0);
        this.f.addCommand(this.c2);
        this.f.addCommand(this.c3);
        this.f.addCommand(this.c1);
        this.f.setCommandListener((CommandListener)this);
        this.name = new TextField("Profile name:", this.j.getName(), 20, 0);
        this.host = new TextField("Host name:", this.j.getHost(), 20, 0);
        this.port = new TextField("Port:", "" + this.j.getPort(), 5, 0);
        this.port.setConstraints(2);
        this.histLength = new TextField("Chat history length:", "" + this.j.getHistLength(), 3, 0);
        this.histLength.setConstraints(2);
        this.user = new TextField("User name:", this.j.getUser(), 40, 0);
        this.pass = new TextField("Password:", this.j.getPass(), 40, 0);
        this.pass.setConstraints(65536);
        this.status = new TextField("Status text:", this.j.getStatus(), 40, 0);
        String[] s = new String[]{"Yes"};
        this.ssl = new ChoiceGroup("SSL?", 2, s, null);
        this.ssl.setSelectedIndex(0, this.j.getSsl() != 0);
        this.auto = new ChoiceGroup("Auto connect", 2, s, null);
        this.auto.setSelectedIndex(0, this.j.getAuto() != 0);
        String[] empty = new String[]{};
        this.sortBy = new ChoiceGroup("Sort by list", 1, empty, null);
        this.sortBy.append("Status, Name", null);
        this.sortBy.append("Name", null);
        this.sortBy.setSelectedIndex(0, this.j.getSortBy() == 0);
        this.sortBy.setSelectedIndex(1, this.j.getSortBy() != 0);
        this.statusID = new ChoiceGroup("Initial status", 1, empty, null);
        this.statusID.append("Online", null);
        this.statusID.append("Away", null);
        this.statusID.append("XA", null);
        this.statusID.append("Busy", null);
        this.statusID.setSelectedIndex(0, this.j.getStatusID() == 0);
        this.statusID.setSelectedIndex(1, this.j.getStatusID() == 1);
        this.statusID.setSelectedIndex(2, this.j.getStatusID() == 2);
        this.statusID.setSelectedIndex(3, this.j.getStatusID() == 3);
        this.offline = new ChoiceGroup("Show offline users?", 2, s, null);
        this.offline.setSelectedIndex(0, this.j.getOffline() != 0);
        this.isGoogle = new ChoiceGroup("GTalk features?", 2, s, null);
        this.isGoogle.setSelectedIndex(0, this.j.getIsGoogle() != 0);
        this.lockStatus = new ChoiceGroup("GTalk  - disable status change by other clients?", 2, s, null);
        this.lockStatus.setSelectedIndex(0, this.j.getLockStatus() != 0);
        this.lockStatusStr = new ChoiceGroup("GTalk  - set status text after login?", 2, s, null);
        this.lockStatusStr.setSelectedIndex(0, this.j.getLockStatusStr() != 0);
        this.autoReconnect = new ChoiceGroup("Enable auto reconnect?", 2, s, null);
        this.autoReconnect.setSelectedIndex(0, this.j.getAutoReconnect() != 0);
        this.smiles = new ChoiceGroup("Show smiles?", 2, s, null);
        this.smiles.setSelectedIndex(0, this.j.getSmiles() != 0);
        this.useMyServer = new ChoiceGroup("GTalk - Use alternative server for Google authorization", 2, s, null);
        this.useMyServer.setSelectedIndex(0, this.j.getUseMyServer() != 0);
        this.volume = new Gauge("Set initial volume", true, 10, this.j.getVolume() / 10);
        this.f.append((Item)this.name);
        this.f.append((Item)this.user);
        this.f.append((Item)this.pass);
        this.f.append((Item)this.host);
        this.f.append((Item)this.ssl);
        this.f.append((Item)this.port);
        this.f.append((Item)this.auto);
        this.f.append((Item)this.autoReconnect);
        this.f.append((Item)this.isGoogle);
        this.f.append((Item)this.useMyServer);
        this.f.append((Item)this.statusID);
        this.f.append((Item)this.lockStatus);
        this.f.append((Item)this.status);
        this.f.append((Item)this.lockStatusStr);
        this.f.append((Item)this.sortBy);
        this.f.append((Item)this.offline);
        this.f.append((Item)this.histLength);
        this.f.append((Item)this.smiles);
        this.f.append((Item)this.volume);
        d.setCurrent((Displayable)this.f);
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0.equals(this.c2)) {
            System.out.println("ID = " + this.j.getId());
            if (this.j.getId() != 0) {
                try {
                    System.out.println("Delete start");
                    this.rs.deleteRecord(this.j.getId());
                    this.rs.closeRecordStore();
                    System.out.println("Delete end");
                }
                catch (RecordStoreNotOpenException e) {
                    e.printStackTrace();
                }
                catch (InvalidRecordIDException e) {
                    e.printStackTrace();
                }
                catch (RecordStoreException e) {
                    e.printStackTrace();
                }
            }
        }
        if (arg0.equals(this.c1)) {
            this.j.setName(this.name.getString());
            this.j.setUser(this.user.getString());
            this.j.setPass(this.pass.getString());
            this.j.setHost(this.host.getString());
            this.j.setStatus(this.status.getString());
            this.j.setPort(Integer.parseInt(this.port.getString()));
            this.j.setHistLength(Integer.parseInt(this.histLength.getString()));
            this.j.setSsl(this.ssl.isSelected(0) ? 1 : 0);
            this.j.setAuto(this.auto.isSelected(0) ? 1 : 0);
            this.j.setSortBy(this.sortBy.getSelectedIndex());
            this.j.setStatusID(this.statusID.getSelectedIndex());
            this.j.setOffline(this.offline.isSelected(0) ? 1 : 0);
            this.j.setIsGoogle(this.isGoogle.isSelected(0) ? 1 : 0);
            this.j.setLockStatus(this.lockStatus.isSelected(0) ? 1 : 0);
            this.j.setLockStatusStr(this.lockStatusStr.isSelected(0) ? 1 : 0);
            this.j.setAutoReconnect(this.autoReconnect.isSelected(0) ? 1 : 0);
            this.j.setSmiles(this.smiles.isSelected(0) ? 1 : 0);
            this.j.setUseMyServer(this.useMyServer.isSelected(0) ? 1 : 0);
            this.j.setVolume(this.volume.getValue() == 0 ? 1 : this.volume.getValue() * 10);
            try {
                System.out.println("J = " + this.j);
                if (this.j.getId() != 0) {
                    System.out.println("Saving old");
                    this.rs.setRecord(this.j.getId(), this.j.toByteArray(), 0, this.j.toByteArray().length);
                } else {
                    System.out.println("Adding new " + this.j.toByteArray().length);
                    this.rs.addRecord(this.j.toByteArray(), 0, this.j.toByteArray().length);
                }
                if (this.j.getAuto() > 0) {
                    RecordEnumeration e = this.rs.enumerateRecords(null, null, false);
                    while (e.hasNextElement()) {
                        int id = e.nextRecordId();
                        JabberProfile tmp = new JabberProfile();
                        tmp.fromByteArray(this.rs.getRecord(id));
                        if (id == this.j.getId() || tmp.getAuto() <= 0) continue;
                        tmp.setAuto(0);
                        this.rs.setRecord(id, tmp.toByteArray(), 0, tmp.toByteArray().length);
                    }
                }
                this.rs.closeRecordStore();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ProfileList l = new ProfileList(this.d);
        System.out.println("Save finish");
    }
}

