/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class RosterFactory {
    private Vector contacts;
    private RosterList list;

    public RosterFactory(RosterList list) {
        this.list = list;
        this.contacts = new Vector();
    }

    public void clear() {
        this.contacts.removeAllElements();
    }

    public RosterItem getItem(int i) {
        return (RosterItem)this.contacts.elementAt(i);
    }

    public void updateContact(String jid, String name, String status, String statusStr) {
        String fullJid = jid;
        if (jid.indexOf("/") != -1) {
            jid = jid.substring(0, jid.indexOf("/"));
        }
        RosterItem ri = null;
        int selIndex = this.list.getRoster().getSelectedIndex();
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!((RosterItem)this.contacts.elementAt(i)).getJid().equals(jid)) continue;
            ri = (RosterItem)this.contacts.elementAt(i);
            this.contacts.removeElement(ri);
            if (this.list.getProfile().getOffline() != 1 && ri.getStatus() == 0) break;
            this.list.getRoster().delete(i);
            break;
        }
        if (ri == null) {
            ri = new RosterItem(this.list, this.list.getDisplay());
            ri.setJid(jid);
        }
        if (name != null) {
            ri.setName(name);
        }
        if (status != null) {
            if (status.equals("")) {
                status = "online";
            }
            if (status.equals("unavailable")) {
                ri.setStatus(0, statusStr, fullJid);
            }
            if (status.equals("online")) {
                ri.setStatus(1, statusStr, fullJid);
            }
            if (status.equals("away")) {
                ri.setStatus(2, statusStr, fullJid);
            }
            if (status.equals("xa")) {
                ri.setStatus(3, statusStr, fullJid);
            }
            if (status.equals("dnd")) {
                ri.setStatus(4, statusStr, fullJid);
            }
        }
        this.insertContact(ri);
        if (selIndex > -1 && this.list.getRoster().size() < selIndex) {
            this.list.getRoster().setSelectedIndex(selIndex, true);
        }
    }

    private void insertContact(RosterItem r) {
        int newInd = -1;
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!((RosterItem)this.contacts.elementAt(i)).compare(r, this.list.getProfile())) continue;
            this.contacts.insertElementAt(r, i);
            if (this.list.getProfile().getOffline() == 1 || r.getStatus() != 0) {
                this.list.getRoster().insert(i, r.getFullName(), r.getImg());
            }
            return;
        }
        this.contacts.addElement(r);
        if (this.list.getProfile().getOffline() == 1 || r.getStatus() != 0) {
            this.list.getRoster().append(r.getFullName(), r.getImg());
        }
    }

    public void refreshItem(String jid) {
        if (jid.indexOf("/") != -1) {
            jid = jid.substring(0, jid.indexOf("/"));
        }
        RosterItem ri = null;
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!((RosterItem)this.contacts.elementAt(i)).getJid().equals(jid)) continue;
            ri = (RosterItem)this.contacts.elementAt(i);
            this.contacts.removeElement(ri);
            if (this.list.getProfile().getOffline() == 1 || ri.getStatus() != 0) {
                this.list.getRoster().delete(i);
            }
            this.insertContact(ri);
            return;
        }
    }

    public void deleteItem(String jid) {
        if (jid.indexOf("/") != -1) {
            jid = jid.substring(0, jid.indexOf("/"));
        }
        RosterItem ri = null;
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!((RosterItem)this.contacts.elementAt(i)).getJid().equals(jid)) continue;
            ri = (RosterItem)this.contacts.elementAt(i);
            this.contacts.removeElement(ri);
            if (this.list.getProfile().getOffline() == 1 || ri.getStatus() != 0) {
                this.list.getRoster().delete(i);
            }
            return;
        }
    }

    public void addMessage(String jid, String mess, String id) {
        if (mess.trim().equals("")) {
            return;
        }
        if (jid.indexOf("/") != -1) {
            jid = jid.substring(0, jid.indexOf("/"));
        }
        RosterItem ri = null;
        for (int i = 0; i < this.contacts.size(); ++i) {
            if (!((RosterItem)this.contacts.elementAt(i)).getJid().equals(jid)) continue;
            this.list.playMessage();
            ri = (RosterItem)this.contacts.elementAt(i);
            ri.addMessage(mess.trim(), true);
            ri.setSession(id);
            this.contacts.removeElement(ri);
            if (this.list.getProfile().getOffline() == 1 || ri.getStatus() != 0) {
                this.list.getRoster().delete(i);
            }
            this.insertContact(ri);
            return;
        }
    }
}

