/*
 * Decompiled with CFR 0.152.
 */
import custom.RichText;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;

public class RosterItem {
    public static String[] smiles = new String[]{":))", ":-))", "=))", ":)", ":-)", "=)", ";)", ";-)", ":D", ":-D", "=D", ":P", ":-P", "=P", ":-p", ":p", "=p", ";P", ";-P", ";p", ";-p", ":lol:", "<lol>", "lol ", "LOL ", ":*", ":-*", ":{}", ":-{}", ":(", ":-(", "=(", ":<", ":-<", "=<", ":cry:", "B)", "B-)"};
    public static String[] smilep = new String[]{"3", "3", "3", "1", "1", "1", "2", "2", "3", "3", "3", "4", "4", "4", "4", "4", "4", "5", "5", "5", "5", "6", "6", "6", "6", "7", "7", "7", "7", "8", "8", "8", "9", "9", "9", "9", "10", "10"};
    private String name = "";
    private String statusStr = "";
    private String jid = "";
    private String fullJid = "";
    private Vector mess = new Vector();
    private Vector times = new Vector();
    boolean isNew = false;
    private String session = "0";
    private Vector statuses = new Vector();
    private MessageForm form = null;
    private Display d;
    private RosterList rl;
    private int status = 0;
    private int index = -1;
    public static Image online = RosterItem.getImage("/imgs/status_avail.png");
    public static Image offline = RosterItem.getImage("/imgs/status_offline.png");
    public static Image away = RosterItem.getImage("/imgs/status_idle.png");
    public static Image xa = RosterItem.getImage("/imgs/status_xa.png");
    public static Image dnd = RosterItem.getImage("/imgs/status_busy.png");

    public void startForm() {
        this.isNew = false;
        this.setStatusInfoForMessage();
        this.form.startForm();
    }

    public void addMessage(String m, boolean from) {
        this.mess.addElement(m);
        Calendar cl = Calendar.getInstance();
        int h = 0;
        h = cl.getTimeZone().useDaylightTime() ? cl.get(11) + 1 : cl.get(11);
        String t = h + ":" + (cl.get(12) < 10 ? "0" + cl.get(12) : "" + cl.get(12));
        RichText message = new RichText(this.d);
        message.setCanvasWidth(this.getMessageForm().getForm().getWidth());
        if (from) {
            this.times.addElement(t + " << ");
            message.addContent(t + " << ", this.rl.getProfile().COLOR_FROM, true);
            message.setDefaultCommand(this.getMessageForm().getQuote());
            message.setItemCommandListener(this.getMessageForm());
        } else {
            this.times.addElement(t + " >> ");
            message.addContent(t + " >> ", this.rl.getProfile().COLOR_TO, true);
        }
        if (this.rl.getProfile().getSmiles() > 0) {
            int i;
            Vector<String> strs = new Vector<String>();
            strs.addElement(m);
            Vector<String> smils = new Vector<String>();
            for (i = 0; i < smiles.length; ++i) {
                for (int j = 0; j < strs.size(); ++j) {
                    int ind = -1;
                    String s = strs.elementAt(j).toString();
                    ind = s.indexOf(smiles[i]);
                    if (ind == -1) continue;
                    String s1 = s.substring(0, ind);
                    String s2 = s.substring(ind + smiles[i].length());
                    strs.insertElementAt(s2, j + 1);
                    strs.removeElementAt(j);
                    strs.insertElementAt(s1, j);
                    smils.insertElementAt(smilep[i], j);
                }
            }
            for (i = 0; i < strs.size(); ++i) {
                message.addContent(strs.elementAt(i).toString());
                if (i >= smils.size()) continue;
                message.addImage(RosterItem.getImage("/smiles/" + smils.elementAt(i) + ".png"));
            }
        } else {
            message.addContent(m);
        }
        message.finish();
        this.getMessageForm().getForm().insert(2, (Item)message);
        this.isNew = true;
        if (this.d.getCurrent() == this.getMessageForm().getForm()) {
            this.isNew = false;
        }
        if (this.mess.size() > this.rl.getProfile().getHistLength()) {
            this.mess.removeElementAt(0);
            this.times.removeElementAt(0);
            this.getMessageForm().getForm().delete(this.getMessageForm().getForm().size() - 1);
        }
    }

    public String getFullName() {
        if (this.isNew) {
            return "* " + this.getName();
        }
        return this.getName();
    }

    public static Image getImage(String s) {
        try {
            return Image.createImage((String)s);
        }
        catch (IOException e) {
            return null;
        }
    }

    public RosterItem(RosterList rl, Display d) {
        this.rl = rl;
        this.d = d;
    }

    private MessageForm getMessageForm() {
        if (this.form == null) {
            this.form = new MessageForm(this.d, this.rl, this);
        }
        return this.form;
    }

    private int min(int i1, int i2) {
        if (i1 > i2) {
            return i2;
        }
        return i1;
    }

    public boolean compare(RosterItem r, JabberProfile jp) {
        if (this.isNew() && !r.isNew()) {
            return false;
        }
        if (!this.isNew() && r.isNew()) {
            return true;
        }
        if (this.getStatus() != 0 && r.getStatus() == 0) {
            return false;
        }
        if (this.getStatus() == 0 && r.getStatus() != 0) {
            return true;
        }
        if (this.getStatus() == r.getStatus() || jp.getSortBy() == 1) {
            int len1 = this.getName().length();
            int len2 = r.getName().length();
            String str1 = this.getName().toLowerCase();
            String str2 = r.getName().toLowerCase();
            for (int i = 0; i < this.min(len1, len2); ++i) {
                if (str1.charAt(i) > str2.charAt(i)) {
                    return true;
                }
                if (str1.charAt(i) >= str2.charAt(i)) continue;
                return false;
            }
            return len1 < len2;
        }
        if (r.getStatus() == 0) {
            return false;
        }
        switch (this.getStatus()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return this.getStatus() > r.getStatus();
    }

    public Image getImg() {
        switch (this.getStatus()) {
            case 0: {
                return offline;
            }
            case 1: {
                return online;
            }
            case 3: {
                return xa;
            }
            case 4: {
                return dnd;
            }
        }
        return away;
    }

    public static Image getImageByStatus(int st) {
        switch (st) {
            case 0: {
                return online;
            }
            case 1: {
                return away;
            }
            case 2: {
                return xa;
            }
            case 3: {
                return dnd;
            }
        }
        return away;
    }

    public String getName() {
        if (this.name != "") {
            return this.name;
        }
        return this.jid;
    }

    public void setName(String name) {
        this.name = name;
        if (this.form != null) {
            this.getMessageForm().getForm().setTitle(name);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status, String statusStr, String fullJid) {
        int i;
        fullJid = fullJid.toLowerCase();
        StatusItem st = null;
        int stIndex = -1;
        for (i = 0; i < this.statuses.size(); ++i) {
            if (!this.statuses.elementAt(i).toString().equals(fullJid)) continue;
            stIndex = i;
            st = (StatusItem)this.statuses.elementAt(i);
        }
        if (stIndex == -1) {
            if (status == 0) {
                return;
            }
            st = new StatusItem(fullJid, statusStr, status);
            this.statuses.addElement(st);
        } else {
            st.setStatus(status);
            st.setStatusText(statusStr);
            this.statuses.removeElementAt(stIndex);
            this.statuses.insertElementAt(st, 0);
        }
        for (i = this.statuses.size() - 1; i >= 0; --i) {
            if (((StatusItem)this.statuses.elementAt(i)).getStatus() != 0) continue;
            this.statuses.removeElementAt(i);
        }
        if (this.statuses.size() == 0) {
            this.status = 0;
            this.statusStr = "";
        }
        int newStatus = 0;
        String newStatusStr = "";
        for (int i2 = 0; i2 < this.statuses.size(); ++i2) {
            st = (StatusItem)this.statuses.elementAt(i2);
            if (st.getStatus() == 1 && newStatus != 1) {
                newStatus = 1;
                newStatusStr = st.getStatusText();
            }
            if (st.getStatus() == 2 && (newStatus == 3 || newStatus == 0)) {
                newStatus = 2;
                newStatusStr = st.getStatusText();
            }
            if (st.getStatus() == 3 && newStatus == 0) {
                newStatus = 3;
                newStatusStr = st.getStatusText();
            }
            if (st.getStatus() != 4 || newStatus == 1) continue;
            newStatus = 4;
            newStatusStr = st.getStatusText();
        }
        this.status = newStatus;
        this.statusStr = newStatusStr;
        if (this.form != null) {
            this.setStatusInfoForMessage();
        }
        System.out.println(this.getStatusStr() + " = " + this.getStatus());
    }

    public void setStatusInfoForMessage() {
        RichText rt = new RichText(this.rl.getDisplay());
        rt.setCanvasWidth(this.rl.getRoster().getWidth());
        rt.addImage(this.getImg());
        rt.addContent(" " + (this.getStatusStr().equals("") ? "<No status text>" : this.getStatusStr()));
        rt.finish();
        this.getMessageForm().getForm().setTitle(this.name);
        this.getMessageForm().getForm().delete(0);
        this.getMessageForm().getForm().insert(0, (Item)rt);
    }

    public String getStatusStr() {
        return this.statusStr;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getJid() {
        return this.jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Vector getMess() {
        return this.mess;
    }
}

