/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class RosterList
implements CommandListener {
    private static RosterList instance;
    private JabberProfile jp;
    private Display d;
    private List roster;
    private NetworkThread thread;
    private RosterFactory factory;
    private Command quit;
    private Command delete;
    private Command add;
    private Command logC;
    private Command status;
    private Command mail;
    private Command rename;
    private Command volume;
    private String fullJid = "";
    private LogViewer log;
    private String lastTime = "";
    private String tid = "";
    private MailViewer mails;
    private Vector onlines = new Vector();
    private Vector busies = new Vector();
    private Vector aways = new Vector();
    Player p = null;

    public void playMessage() {
        try {
            if (this.p == null) {
                this.p = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/imgs/ring.mid"), (String)"audio/midi");
            }
            if (this.p.getState() != 400) {
                this.p.realize();
                Control[] cs = this.p.getControls();
                for (int i = 0; i < cs.length; ++i) {
                    if (!(cs[i] instanceof VolumeControl)) continue;
                    try {
                        if (((VolumeControl)cs[i]).getLevel() == this.getProfile().getVolume()) continue;
                        ((VolumeControl)cs[i]).setLevel(this.getProfile().getVolume());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.p.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RosterList(Display d, JabberProfile jp) {
        this.d = d;
        this.jp = jp;
        this.setFullJid(jp.getUser());
        this.roster = new List("", 3);
    }

    public void init() {
        this.d.setCurrent((Displayable)this.roster);
        this.quit = new Command("Close session", 2, 6);
        this.roster.addCommand(this.quit);
        this.delete = new Command("Delete", 2, 4);
        this.roster.addCommand(this.delete);
        this.add = new Command("Add", 2, 2);
        this.roster.addCommand(this.add);
        this.status = new Command("Status", 2, 0);
        this.roster.addCommand(this.status);
        this.mail = new Command("Mailbox", 2, 1);
        this.roster.addCommand(this.mail);
        this.rename = new Command("Rename", 2, 3);
        this.roster.addCommand(this.rename);
        this.volume = new Command("Volume", 2, 5);
        this.roster.addCommand(this.volume);
        this.log = new LogViewer(this.d, this);
        this.mails = new MailViewer(this.d, this);
        this.roster.setCommandListener((CommandListener)this);
        this.factory = new RosterFactory(this);
    }

    public RosterFactory getRosterFactory() {
        return this.factory;
    }

    public List getRoster() {
        return this.roster;
    }

    public JabberProfile getProfile() {
        return this.jp;
    }

    public Display getDisplay() {
        return this.d;
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0.equals(this.quit)) {
            this.thread.terminate(false);
            new ProfileList(this.d);
            return;
        }
        if (arg0.equals(this.delete) && this.roster.size() > 0) {
            this.thread.writeToAir("<presence to=\"" + this.factory.getItem(this.roster.getSelectedIndex()).getJid() + "\" type=\"unsubscribe\"/>");
            this.factory.deleteItem(this.factory.getItem(this.roster.getSelectedIndex()).getJid());
            return;
        }
        if (arg0.equals(this.rename) && this.roster.size() > 0) {
            new ContactRename(this.d, this, this.thread, this.factory.getItem(this.roster.getSelectedIndex()));
            return;
        }
        if (arg0.equals(this.add)) {
            new ContactAdd(this.d, this.d.getCurrent(), this.thread);
            return;
        }
        if (arg0.equals(this.status)) {
            new ChangeStatus(this, this.d);
            return;
        }
        if (arg0.equals(this.mail)) {
            this.mails.startMe();
            return;
        }
        if (arg0.equals(this.volume)) {
            new VolumeSetup(this.d, this);
            return;
        }
        if (this.roster.size() > 0) {
            this.factory.getItem(this.roster.getSelectedIndex()).startForm();
            this.factory.refreshItem(this.factory.getItem(this.roster.getSelectedIndex()).getJid());
        }
    }

    public NetworkThread getThread() {
        return this.thread;
    }

    public String getFullJid() {
        return this.fullJid;
    }

    public void setFullJid(String fullJid) {
        this.fullJid = fullJid;
    }

    public LogViewer getLog() {
        return this.log;
    }

    public String getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(String lastTime) {
        this.lastTime = lastTime;
    }

    public MailViewer getMails() {
        return this.mails;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public Vector getBusies() {
        return this.busies;
    }

    public void setBusies(Vector busies) {
        this.busies = busies;
    }

    public Vector getOnlines() {
        return this.onlines;
    }

    public void setOnlines(Vector onlines) {
        this.onlines = onlines;
    }

    public Vector getAways() {
        return this.aways;
    }

    public void setThread(NetworkThread thread) {
        this.thread = thread;
    }
}

