/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.RichText;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RichItem {
    private String content = null;
    private Image image = null;
    private int color = -1;
    private boolean bold = false;
    private Vector words = new Vector();
    private RichText parent;
    private int x;
    private int y;
    private int height;
    private int wordHeight = 0;

    public RichItem(RichText parent) {
        this.parent = parent;
        this.wordHeight = parent.getBold().getHeight() > parent.getNormal().getHeight() ? parent.getBold().getHeight() : parent.getNormal().getHeight();
    }

    private int wordWidth(String word) {
        if (this.bold) {
            return this.parent.getBold().stringWidth(word);
        }
        return this.parent.getNormal().stringWidth(word);
    }

    private void cutToWords() {
        this.words.removeAllElements();
        String tmp = this.content;
        for (int i = 0; i < tmp.length(); ++i) {
            if (tmp.charAt(i) != ' ' && tmp.charAt(i) != ',' && tmp.charAt(i) != '.' && tmp.charAt(i) != '!' && tmp.charAt(i) != '?' && tmp.charAt(i) != '\n' && tmp.charAt(i) != ';' && tmp.charAt(i) != ':' && tmp.charAt(i) != '-' && tmp.charAt(i) != '+' && this.wordWidth(tmp.substring(0, i + 1)) <= this.parent.getCanvasWidth()) continue;
            String word = "";
            if (this.wordWidth(tmp.substring(0, i + 1)) > this.parent.getCanvasWidth()) {
                word = tmp.substring(0, i);
                tmp = tmp.substring(i, tmp.length());
            } else {
                word = tmp.substring(0, i + 1);
                tmp = tmp.substring(i + 1, tmp.length());
            }
            this.words.addElement(word);
            i = -1;
        }
        if (!tmp.equals("")) {
            this.words.addElement(tmp);
        }
    }

    public void setContent(String content, int color, boolean bold) {
        this.content = content;
        this.bold = bold;
        this.color = color;
        this.image = null;
        this.cutToWords();
    }

    public void setImage(Image image) {
        this.image = image;
        this.content = null;
    }

    void recalcHeight(int x, int y, int height) {
        if (this.image != null) {
            if (this.image.getHeight() > height) {
                height = this.image.getHeight();
            }
            if (this.image.getWidth() + x > this.parent.getCanvasWidth()) {
                if (y == 0) {
                    y = height;
                }
                y += height;
                x = this.image.getWidth();
            } else {
                if (this.image.getHeight() > height) {
                    height = this.image.getHeight();
                }
                x += this.image.getWidth();
            }
        } else {
            for (int i = 0; i < this.words.size(); ++i) {
                String word = (String)this.words.elementAt(i);
                int ww = this.wordWidth(word);
                if (ww + x > this.parent.getCanvasWidth()) {
                    if (y == 0) {
                        y = height;
                    }
                    y += height;
                    x = ww;
                    height = this.wordHeight;
                } else {
                    if (this.wordHeight > height) {
                        height = this.wordHeight;
                    }
                    x += ww;
                }
                if (word.charAt(word.length() - 1) != '\n') continue;
                if (y == 0) {
                    y = height;
                }
                y += height;
                x = 0;
                height = this.wordHeight;
            }
        }
        this.x = x;
        this.y = y;
        this.height = height;
    }

    private String getWord(String word) {
        if (word.charAt(word.length() - 1) == '\n') {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    void paint(Graphics g, int x, int y, int height) {
        if (this.image != null) {
            if (this.image.getWidth() + x > this.parent.getCanvasWidth()) {
                x = this.image.getWidth();
                g.drawImage(this.image, 0, y += height, 20);
                height = this.image.getHeight();
            } else {
                g.drawImage(this.image, x, y, 20);
                if (this.image.getHeight() > height) {
                    height = this.image.getHeight();
                }
                x += this.image.getWidth();
            }
        } else {
            for (int i = 0; i < this.words.size(); ++i) {
                String word = (String)this.words.elementAt(i);
                g.setColor(this.color);
                g.setFont(this.bold ? this.parent.getBold() : this.parent.getNormal());
                int ww = this.wordWidth(word);
                if (ww + x > this.parent.getCanvasWidth()) {
                    x = ww;
                    g.drawString(this.getWord(word), 0, y += height, 20);
                    height = this.wordHeight;
                } else {
                    g.drawString(this.getWord(word), x, y, 20);
                    if (this.wordHeight > height) {
                        height = this.wordHeight;
                    }
                    x += ww;
                }
                if (word.charAt(word.length() - 1) != '\n') continue;
                y += height;
                x = 0;
                height = this.wordHeight;
            }
        }
        this.x = x;
        this.y = y;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }
}

