/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.RichItem;
import java.util.Vector;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RichText
extends CustomItem {
    private int canvasWidth;
    private Font normal = Font.getFont((int)0, (int)0, (int)0);
    private Font bold = Font.getFont((int)0, (int)1, (int)0);
    private int defaultColor = -1;
    int textHeight = 0;
    private Vector items = new Vector();
    boolean finished = false;

    public RichText(Display d) {
        super(null);
        this.defaultColor = d.getColor(1);
        this.recalcHeight();
    }

    public void finish() {
        this.finished = true;
    }

    protected int getMinContentWidth() {
        return this.getPrefContentWidth(0);
    }

    protected int getMinContentHeight() {
        return this.getPrefContentHeight(0);
    }

    protected int getPrefContentWidth(int arg0) {
        return this.getCanvasWidth();
    }

    protected int getPrefContentHeight(int arg0) {
        return this.textHeight + 5;
    }

    protected void paint(Graphics arg0, int arg1, int arg2) {
        if (!this.finished) {
            return;
        }
        int x = 0;
        int y = 0;
        int height = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            RichItem ri = (RichItem)this.items.elementAt(i);
            ri.paint(arg0, x, y, height);
            x = ri.getX();
            y = ri.getY();
            height = ri.getHeight();
        }
    }

    public int getCanvasWidth() {
        return this.canvasWidth == 0 ? 1 : this.canvasWidth;
    }

    public void setCanvasWidth(int canvasWidth) {
        this.canvasWidth = canvasWidth;
    }

    public Font getBold() {
        return this.bold;
    }

    public Font getNormal() {
        return this.normal;
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public void recalcHeight() {
        int x = 0;
        int y = 0;
        int height = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            RichItem ri = (RichItem)this.items.elementAt(i);
            ri.recalcHeight(x, y, height);
            x = ri.getX();
            y = ri.getY();
            height = ri.getHeight();
        }
        this.textHeight = y == 0 ? height : y;
        this.setPreferredSize(this.getPrefContentWidth(0), (y == 0 ? height : y) + 3);
    }

    public void addContent(String content, int color, boolean bold) {
        if (this.finished) {
            return;
        }
        RichItem ri = new RichItem(this);
        ri.setContent(content, color, bold);
        this.items.addElement(ri);
        this.recalcHeight();
    }

    public void addContent(String content, int color) {
        this.addContent(content, color, false);
    }

    public void addContent(String content) {
        this.addContent(content, this.getDefaultColor(), false);
    }

    public void reset() {
        this.items.removeAllElements();
        this.finished = false;
    }

    public void addImage(Image img) {
        if (this.finished) {
            return;
        }
        RichItem ri = new RichItem(this);
        ri.setImage(img);
        this.items.addElement(ri);
        this.recalcHeight();
    }
}

